*Median earnings by social class for specific subgroups in the population

*Tim Goedemé, 27/04/2021

/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/

This file makes use of the epctile1 command, which I adapted from 'epctile' but is not available online.
Please contact me in case you would like to have access to this command.

*/

*Globals

global place1 << data directory ... \2020-04\ >>
global place2 <<output 1 directory >>
global place3 <<output 2 directory >>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK


*by gender
**********


foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			cap drop class08
			
			gen class08 = 1 if esec08<3
			replace class08 = 2 if esec08>=3 & esec08<7
			replace class08 = 3 if esec08>=7 & esec08!=.
			
			gen classgen = class08*10+sex
			
			replace sub=0 if earns2<=0
			
			epctile1 earns2, over(classgen) p(50) subpop(sub)
			
			mat def temp1 = e(results)
			
			
			mat def results = nullmat(results) \ temp1

			
			di "."
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\MedEarn_`ctry'_3_Classgen.dta", replace // esec08
	}
}

*Putting estimations together

clear
foreach ctry of global countries {
	append using "${place2}\MedEarn_`ctry'_3_Classgen.dta"
}
save "${place2}\MedianEarnings_3_ClassGen_2018.dta", replace

*Reordering info to create graph in excel
use "${place2}\MedianEarnings_3_ClassGen_2018.dta", clear

gen CIarm = UB-est

drop se Percentile DF LB UB

reshape wide est CIarm, i(country) j(classgen)
order _all, seq


*by household type
*******************


foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			cap drop class08
			
			gen class08 = 1 if esec08<3
			replace class08 = 2 if esec08>=3 & esec08<7
			replace class08 = 3 if esec08>=7 & esec08!=.
			
			gen hhtype = 1 if single==1
			replace hhtype = 2 if nadults+ndepadults==2 & nchilds==0
			replace hhtype = 3 if singleparent==1
			replace hhtype = 4 if nadults+ndepadults==2 & nchilds>0
			
			gen classHH = class08*10+hhtype
			
			replace sub=0 if earns2<=0
			
			epctile1 earns2, over(classHH) p(50) subpop(sub)
			
			mat def temp1 = e(results)
			
			
			mat def results = nullmat(results) \ temp1

			
			di "."
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\MedEarn_`ctry'_3_ClassHHtype.dta", replace // esec08
	}
}

*Putting estimations together

clear
foreach ctry of global countries {
	append using "${place2}\MedEarn_`ctry'_3_ClassHHtype.dta"
}
save "${place2}\MedianEarnings_3_ClassHHtype_2018.dta", replace

*Reordering info to create graph in excel
use "${place2}\MedianEarnings_3_ClassHHtype_2018.dta", clear

gen CIarm = UB-est

drop se Percentile DF LB UB

reshape wide est CIarm, i(country) j(classHH)
order _all, seq

browse country 
